/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.openzen.entitysyncer.structured.definition.StructuredObjectClass;
import org.openzen.packetstreams.io.DataInput;

/**
 *
 * @author Hoofdgebruiker
 */
public class StructuredDataInputStream {
	private final StructuredClassRegistry registry;
	private final List<UUID> classIds = new ArrayList<>();
	private final Map<UUID, Integer> classIndices = new HashMap<>();
	private final StructuredDataset dataset;
	
	public StructuredDataInputStream(StructuredClassRegistry registry, StructuredDataset dataset) {
		this.registry = registry;
		this.dataset = dataset;
		
		classIds.add(null); // 0: use class
		classIds.add(null); // 1: define ad-hoc class (also creates a reference)
	}
	
	public StructuredObject readStructuredObject(DataInput input) {
		UUID clsid = readClass(input);
		if (!registry.knows(clsid))
			throw new RuntimeException("Unknown class: " + clsid);
		
		return registry.read(clsid, this, input);
	}
	
	private UUID readClass(DataInput input) {
		int id = input.readVarUInt();
		if (id == 0) {
			UUID uuid = input.readUUID();
			int newid = classIds.size();
			classIds.add(uuid);
			classIndices.put(uuid, newid);
			return uuid;
		} else if (id == 1) {
			StructuredObjectClass definition = new StructuredObjectClass(input);
			if (!registry.knows(definition.id))
				registry.register(definition);
			
			int newid = classIds.size();
			classIds.add(definition.id);
			classIndices.put(definition.id, newid);
			return definition.id;
		} else {
			return classIds.get(id);
		}
	}
}
