/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured;

import java.util.List;
import org.openzen.entitysyncer.structured.definition.StructuredFieldDefinition;
import org.openzen.entitysyncer.structured.definition.StructuredObjectClass;
import org.openzen.entitysyncer.structured.value.IValue;
import org.openzen.packetstreams.io.DataInput;
import org.openzen.packetstreams.io.DataOutput;

/**
 *
 * @author Hoofdgebruiker
 */
public class StructuredGenericObject implements StructuredObject {
	private final StructuredObject subObject;
	private final StructuredObjectClass cls;
	private List<StructuredField> fields;
	
	public StructuredGenericObject(StructuredObject subObject, StructuredObjectClass cls, StructuredDataInputStream scope, DataInput input) {
		this.subObject = subObject;
		this.cls = cls;
		
		long fieldsMask = input.readVarULong();
		int index = 0;
		for (StructuredFieldDefinition field : cls.getFields()) {
			long fieldMask = 1L << index;
			if ((fieldsMask & fieldMask) > 0) {
				fieldsMask &= ~fieldMask;
				fields.add(field.read(scope, input));
			}
			
			index++;
		}
		
		if (fieldsMask != 0) {
			throw new RuntimeException("Illegal object: one or more fields were not deserialized");
		}
	}

	@Override
	public StructuredObjectClass getStructuredClass() {
		return cls;
	}

	@Override
	public StructuredField getField(int index) {
		return fields.get(index);
	}

	@Override
	public void setField(int index, StructuredDataset dataset, IValue value) {
		fields.set(index, cls.getField(index).type.get(dataset, value));
	}

	@Override
	public void serialize(StructuredDataOutputStream scope, DataOutput output) {
		if (subObject != null)
			subObject.serialize(scope, output);
		
		long fieldMask = 0;
		for (int i = 0; i < fields.size(); i++) {
			if (fields.get(i) != null)
				fieldMask |= (1L << i);
		}
		
		output.writeVarULong(fieldMask);
		
		for (StructuredField field : fields) {
			if (field == null)
				continue;
			
			field.serialize(scope, output);
		}
	}

	@Override
	public <T extends StructuredObject> T as(Class<T> cls) {
		return subObject == null ? null : subObject.as(cls);
	}
}
