/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured;

import java.util.HashMap;
import java.util.Map;
import org.openzen.entitysyncer.structured.definition.StructuredFieldType;

/**
 *
 * @author Hoofdgebruiker
 */
public class StructuredObjectEditor {
	private final StructuredObject object;
	private final Map<Integer, StructuredField> updatedFields = new HashMap<>();
	
	public StructuredObjectEditor(StructuredObject object) {
		this.object = object;
	}
	
	public void setInt(int field, int value) {
		updatedFields.put(field, getFieldType(field).getInt(value));
	}
	
	public void setLong(int field, long value) {
		updatedFields.put(field, getFieldType(field).getLong(value));
	}
	
	public void setFloat(int field, float value) {
		updatedFields.put(field, getFieldType(field).getFloat(value));
	}
	
	public void setDouble(int field, double value) {
		updatedFields.put(field, getFieldType(field).getDouble(value));
	}
	
	public void setString(int field, String value) {
		updatedFields.put(field, getFieldType(field).getString(value));
	}
	
	public void validate() {
		
	}
	
	private StructuredFieldType getFieldType(int field) {
		return object.getStructuredClass().getField(field).type;
	}
}
