/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured.commit;

import org.openzen.packetstreams.io.DataInput;

/**
 *
 * @author Hoofdgebruiker
 */
public class SetBoolFieldOperation extends StructuredSetOperation {
	private final boolean value;
	
	public SetBoolFieldOperation(int object, int field, boolean value) {
		super(object, field);
		this.value = value;
	}
	
	public SetBoolFieldOperation(DataInput input, boolean value) {
		super(input);
		this.value = value;
	}
	
	@Override
	public boolean asBool() {
		return value;
	}
	
	@Override
	public String asString() {
		return Boolean.toString(value);
	}
}
