/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured.commit;

import org.openzen.packetstreams.io.DataInput;

/**
 *
 * @author Hoofdgebruiker
 */
public class SetDoubleFieldOperation extends StructuredSetOperation {
	private final double value;
	
	public SetDoubleFieldOperation(int object, int field, double value) {
		super(object, field);
		
		this.value = value;
	}
	
	public SetDoubleFieldOperation(DataInput input) {
		super(input);
		
		value = input.readDouble();
	}
	
	@Override
	public int asInt() {
		return (int) value;
	}
	
	@Override
	public long asLong() {
		return (long) value;
	}
	
	@Override
	public float asFloat() {
		return (float) value;
	}
	
	@Override
	public double asDouble() {
		return value;
	}
	
	@Override
	public String asString() {
		return Double.toString(value);
	}
}
