/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured.commit;

import org.openzen.packetstreams.io.DataInput;

/**
 *
 * @author Hoofdgebruiker
 */
public class SetFloatFieldOperation extends StructuredSetOperation {
	private final float value;
	
	public SetFloatFieldOperation(int object, int field, float value) {
		super(object, field);
		
		this.value = value;
	}
	
	public SetFloatFieldOperation(DataInput input) {
		super(input);
		
		this.value = input.readFloat();
	}
	
	@Override
	public int asInt() {
		return (int) value;
	}
	
	@Override
	public long asLong() {
		return (long) value;
	}
	
	@Override
	public float asFloat() {
		return value;
	}
	
	@Override
	public double asDouble() {
		return value;
	}
	
	@Override
	public String toString() {
		return Float.toString(value);
	}
}
