/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured.commit;

import org.openzen.packetstreams.io.DataInput;

/**
 *
 * @author Hoofdgebruiker
 */
public class SetIntFieldOperation extends StructuredSetOperation {
	private final int value;
	
	public SetIntFieldOperation(int object, int field, int value) {
		super(object, field);
		
		this.value = value;
	}
	
	public SetIntFieldOperation(DataInput input) {
		super(input);
		
		value = input.readVarInt();
	}
	
	@Override
	public int asInt() {
		return value;
	}
	
	@Override
	public long asLong() {
		return value;
	}
	
	@Override
	public float asFloat() {
		return value;
	}
	
	@Override
	public double asDouble() {
		return value;
	}
	
	@Override
	public String asString() {
		return Integer.toString(value);
	}
}
