/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured.commit;

import org.openzen.packetstreams.io.DataInput;

/**
 *
 * @author Hoofdgebruiker
 */
public class SetLongFieldOperation extends StructuredSetOperation {
	private final long value;
	
	public SetLongFieldOperation(int object, int field, long value) {
		super(object, field);
		
		this.value = value;
	}
	
	public SetLongFieldOperation(DataInput input) {
		super(input);
		
		this.value = input.readVarLong();
	}
	
	@Override
	public int asInt() {
		return (int) value;
	}
	
	@Override
	public long asLong() {
		return value;
	}
	
	@Override
	public float asFloat() {
		return value;
	}
	
	@Override
	public double asDouble() {
		return value;
	}
	
	@Override
	public String asString() {
		return Long.toString(value);
	}
}
