/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured.commit;

import org.openzen.packetstreams.io.DataInput;

/**
 *
 * @author Hoofdgebruiker
 */
public class SetStringFieldOperation extends StructuredSetOperation {
	private final String value;
	
	public SetStringFieldOperation(int object, int field, String value) {
		super(object, field);
		
		this.value = value;
	}
	
	public SetStringFieldOperation(DataInput input) {
		super(input);
		
		value = input.readString();
	}
	
	@Override
	public boolean asBool() {
		return Boolean.parseBoolean(value);
	}
	
	@Override
	public int asInt() {
		return Integer.parseInt(value);
	}
	
	@Override
	public long asLong() {
		return Long.parseLong(value);
	}
	
	@Override
	public float asFloat() {
		return Float.parseFloat(value);
	}
	
	@Override
	public double asDouble() {
		return Double.parseDouble(value);
	}
	
	@Override
	public String asString() {
		return value;
	}
}
