/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured.commit;

import org.openzen.entitysyncer.structured.StructuredDataset;
import org.openzen.entitysyncer.structured.StructuredObject;
import org.openzen.entitysyncer.structured.value.IValue;
import org.openzen.packetstreams.io.DataInput;

/**
 *
 * @author Hoofdgebruiker
 */
public class StructuredSetOperation implements StructuredOperation, IValue {
	private final int object;
	private final int field;
	
	public StructuredSetOperation(int object, int field) {
		this.object = object;
		this.field = field;
	}
	
	public StructuredSetOperation(DataInput input) {
		object = input.readVarInt();
		field = input.readVarUInt();
	}

	@Override
	public void apply(StructuredDataset dataset) {
		StructuredObject object = dataset.getObject(this.object);
		if (object == null)
			return; // ignore operation on deleted object
		
		object.setField(field, dataset, this);
	}

	@Override
	public boolean asBool() {
		throw new IllegalArgumentException("Cannot convert this value to a bool");
	}

	@Override
	public int asInt() {
		throw new IllegalArgumentException("Cannot convert this value to an int");
	}

	@Override
	public long asLong() {
		throw new IllegalArgumentException("Cannot convert this value to a long");
	}

	@Override
	public float asFloat() {
		throw new IllegalArgumentException("Cannot convert this value to a float");
	}

	@Override
	public double asDouble() {
		throw new IllegalArgumentException("Cannot convert this value to a double");
	}

	@Override
	public String asString() {
		throw new IllegalArgumentException("Cannot convert this value to a string");
	}

	@Override
	public int asObjectId() {
		throw new IllegalArgumentException("Cannot convert this value to an object");
	}
}
