/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured.definition;

import org.openzen.entitysyncer.structured.StructuredDataInputStream;
import org.openzen.entitysyncer.structured.StructuredDataset;
import org.openzen.entitysyncer.structured.StructuredObject;
import org.openzen.entitysyncer.structured.fields.StructuredDoubleField;
import org.openzen.entitysyncer.structured.fields.StructuredLongField;
import org.openzen.entitysyncer.structured.value.IValue;
import org.openzen.packetstreams.io.DataInput;
import org.openzen.entitysyncer.structured.StructuredField;

/**
 *
 * @author Hoofdgebruiker
 */
public class DoubleFieldType implements StructuredFieldType {
	public static final DoubleFieldType INSTANCE = new DoubleFieldType();
	
	private DoubleFieldType() {}

	@Override
	public StructuredField getBool(boolean value) {
		return new StructuredDoubleField(value ? 1 : 0);
	}

	@Override
	public StructuredField getInt(int value) {
		return new StructuredDoubleField(value);
	}

	@Override
	public StructuredField getLong(long value) {
		return new StructuredDoubleField(value);
	}

	@Override
	public StructuredField getFloat(float value) {
		return new StructuredDoubleField(value);
	}

	@Override
	public StructuredField getDouble(double value) {
		return new StructuredDoubleField(value);
	}

	@Override
	public StructuredField getString(String value) {
		return new StructuredDoubleField(Double.parseDouble(value));
	}

	@Override
	public StructuredField getObject(StructuredObject value) {
		throw new ClassCastException("Cannot convert object to double");
	}

	@Override
	public StructuredField read(StructuredDataInputStream scope, DataInput input) {
		return new StructuredDoubleField(input.readDouble());
	}

	@Override
	public StructuredField get(StructuredDataset dataset, IValue value) {
		return new StructuredDoubleField(value.asDouble());
	}
}
