/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured.definition;

import org.openzen.entitysyncer.structured.StructuredDataInputStream;
import org.openzen.entitysyncer.structured.StructuredDataset;
import org.openzen.entitysyncer.structured.StructuredObject;
import org.openzen.entitysyncer.structured.fields.StructuredIntField;
import org.openzen.entitysyncer.structured.value.IValue;
import org.openzen.packetstreams.io.DataInput;
import org.openzen.entitysyncer.structured.StructuredField;

/**
 *
 * @author Hoofdgebruiker
 */
public class IntFieldType implements StructuredFieldType {
	public static final IntFieldType INSTANCE = new IntFieldType();
	
	private IntFieldType() {}

	@Override
	public StructuredField getBool(boolean value) {
		return new StructuredIntField(value ? 1 : 0);
	}
	
	@Override
	public StructuredField getInt(int value) {
		return new StructuredIntField(value);
	}

	@Override
	public StructuredField getLong(long value) {
		return new StructuredIntField((int) value);
	}

	@Override
	public StructuredField getFloat(float value) {
		return new StructuredIntField((int) value);
	}

	@Override
	public StructuredField getDouble(double value) {
		return new StructuredIntField((int) value);
	}

	@Override
	public StructuredField getString(String value) {
		return new StructuredIntField(Integer.parseInt(value));
	}

	@Override
	public StructuredField getObject(StructuredObject value) {
		throw new ClassCastException("Cannot convert a structured object to an int");
	}

	@Override
	public StructuredField read(StructuredDataInputStream scope, DataInput input) {
		return new StructuredIntField(input.readVarInt());
	}

	@Override
	public StructuredField get(StructuredDataset dataset, IValue value) {
		return new StructuredIntField(value.asInt());
	}
}
