/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured.definition;

import org.openzen.entitysyncer.structured.StructuredDataInputStream;
import org.openzen.entitysyncer.structured.StructuredDataset;
import org.openzen.entitysyncer.structured.StructuredObject;
import org.openzen.entitysyncer.structured.fields.StructuredLongField;
import org.openzen.entitysyncer.structured.value.IValue;
import org.openzen.packetstreams.io.DataInput;
import org.openzen.entitysyncer.structured.StructuredField;

/**
 *
 * @author Hoofdgebruiker
 */
public class LongFieldType implements StructuredFieldType {
	public static final LongFieldType INSTANCE = new LongFieldType();
	
	private LongFieldType() {}

	@Override
	public StructuredField getBool(boolean value) {
		return new StructuredLongField(value ? 1 : 0);
	}

	@Override
	public StructuredField getInt(int value) {
		return new StructuredLongField(value);
	}

	@Override
	public StructuredField getLong(long value) {
		return new StructuredLongField(value);
	}

	@Override
	public StructuredField getFloat(float value) {
		return new StructuredLongField((long) value);
	}

	@Override
	public StructuredField getDouble(double value) {
		return new StructuredLongField((long) value);
	}

	@Override
	public StructuredField getString(String value) {
		return new StructuredLongField(Long.parseLong(value));
	}

	@Override
	public StructuredField getObject(StructuredObject value) {
		throw new ClassCastException("Cannot convert object to long");
	}

	@Override
	public StructuredField read(StructuredDataInputStream scope, DataInput input) {
		return new StructuredLongField(input.readVarLong());
	}

	@Override
	public StructuredField get(StructuredDataset dataset, IValue value) {
		return new StructuredLongField(value.asLong());
	}
}
