/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured.definition;

import org.openzen.entitysyncer.structured.StructuredDataInputStream;
import org.openzen.entitysyncer.structured.StructuredDataset;
import org.openzen.entitysyncer.structured.StructuredObject;
import org.openzen.entitysyncer.structured.value.IValue;
import org.openzen.packetstreams.io.DataInput;
import org.openzen.entitysyncer.structured.StructuredField;

/**
 *
 * @author Hoofdgebruiker
 */
public interface StructuredFieldType {
	public static final int TYPE_NONE = 0;
	public static final int TYPE_BOOL = 1;
	public static final int TYPE_INT = 2;
	public static final int TYPE_LONG = 3;
	public static final int TYPE_FLOAT = 4;
	public static final int TYPE_DOUBLE = 5;
	public static final int TYPE_STRING = 6;
	public static final int TYPE_OBJECT = 7;
	
	public StructuredField getBool(boolean value);
	
	public StructuredField getInt(int value);
	
	public StructuredField getLong(long value);
	
	public StructuredField getFloat(float value);
	
	public StructuredField getDouble(double value);
	
	public StructuredField getString(String value);
	
	public StructuredField getObject(StructuredObject value);
	
	public StructuredField read(StructuredDataInputStream scope, DataInput input);
	
	public StructuredField get(StructuredDataset dataset, IValue value);
}
