/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured.fields;

import org.openzen.entitysyncer.structured.StructuredDataOutputStream;
import org.openzen.entitysyncer.structured.StructuredObject;
import org.openzen.packetstreams.io.DataOutput;
import org.openzen.entitysyncer.structured.StructuredField;

/**
 *
 * @author Hoofdgebruiker
 */
public class StructuredDoubleField implements StructuredField {
	public final double value;
	
	public StructuredDoubleField(double value) {
		this.value = value;
	}

	@Override
	public boolean getBool() {
		throw new ClassCastException("Cannot convert double to bool");
	}

	@Override
	public int getInt() {
		return (int) value;
	}

	@Override
	public long getLong() {
		return (long) value;
	}

	@Override
	public float getFloat() {
		return (float) value;
	}

	@Override
	public double getDouble() {
		return value;
	}

	@Override
	public String getString() {
		return Double.toString(value);
	}

	@Override
	public StructuredObject getObject() {
		throw new ClassCastException("Cannot convert double to object");
	}

	@Override
	public void serialize(StructuredDataOutputStream scope, DataOutput output) {
		output.writeDouble(value);
	}
}
