/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.entitysyncer.structured;

import java.util.List;
import org.openzen.entitysyncer.structured.StructuredDataInputStream;
import org.openzen.entitysyncer.structured.StructuredDataOutputStream;
import org.openzen.entitysyncer.structured.StructuredDataset;
import org.openzen.entitysyncer.structured.StructuredField;
import org.openzen.entitysyncer.structured.StructuredObject;
import org.openzen.entitysyncer.structured.definition.StructuredFieldDefinition;
import org.openzen.entitysyncer.structured.definition.StructuredObjectClass;
import org.openzen.entitysyncer.structured.value.IValue;
import org.openzen.packetstreams.io.DataInput;
import org.openzen.packetstreams.io.DataOutput;

public class StructuredGenericObject
implements StructuredObject {
    private final StructuredObject subObject;
    private final StructuredObjectClass cls;
    private List<StructuredField> fields;

    public StructuredGenericObject(StructuredObject subObject, StructuredObjectClass cls, StructuredDataInputStream scope, DataInput input) {
        this.subObject = subObject;
        this.cls = cls;
        long fieldsMask = input.readVarULong();
        int index = 0;
        for (StructuredFieldDefinition field : cls.getFields()) {
            long fieldMask = 1L << index;
            if ((fieldsMask & fieldMask) > 0L) {
                fieldsMask &= fieldMask ^ 0xFFFFFFFFFFFFFFFFL;
                this.fields.add(field.read(scope, input));
            }
            ++index;
        }
        if (fieldsMask != 0L) {
            throw new RuntimeException("Illegal object: one or more fields were not deserialized");
        }
    }

    @Override
    public StructuredObjectClass getStructuredClass() {
        return this.cls;
    }

    @Override
    public StructuredField getField(int index) {
        return this.fields.get(index);
    }

    @Override
    public void setField(int index, StructuredDataset dataset, IValue value) {
        this.fields.set(index, this.cls.getField((int)index).type.get(dataset, value));
    }

    @Override
    public void serialize(StructuredDataOutputStream scope, DataOutput output) {
        if (this.subObject != null) {
            this.subObject.serialize(scope, output);
        }
        long fieldMask = 0L;
        for (int i = 0; i < this.fields.size(); ++i) {
            if (this.fields.get(i) == null) continue;
            fieldMask |= 1L << i;
        }
        output.writeVarULong(fieldMask);
        for (StructuredField field : this.fields) {
            if (field == null) continue;
            field.serialize(scope, output);
        }
    }

    @Override
    public <T extends StructuredObject> T as(Class<T> cls) {
        return this.subObject == null ? null : (T)this.subObject.as(cls);
    }
}

