/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.entitysyncer.structured;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openzen.entitysyncer.datasets.DatasetSubscriber;
import org.openzen.entitysyncer.datasets.DatasetSubscription;
import org.openzen.entitysyncer.structured.StructuredClassRegistry;
import org.openzen.entitysyncer.structured.StructuredDataOutputStream;
import org.openzen.entitysyncer.structured.StructuredDataset;
import org.openzen.entitysyncer.structured.StructuredObject;
import org.openzen.entitysyncer.structured.commit.StructuredCommitHistoryItem;
import org.openzen.packetstreams.ByteString;
import org.openzen.packetstreams.io.BytesDataOutput;
import org.openzen.packetstreams.io.DataOutput;

public class StructuredMemoryDataset
implements StructuredDataset {
    private final StructuredClassRegistry registry;
    public final StructuredObject root;
    private final List<Subscription> subscriptions = new ArrayList<Subscription>();
    private final List<StructuredObject> objects = new ArrayList<StructuredObject>();
    private final Map<StructuredObject, Integer> idsByObject = new HashMap<StructuredObject, Integer>();
    private final Map<ByteString, StructuredCommitHistoryItem> commitHistory = new HashMap<ByteString, StructuredCommitHistoryItem>();
    private byte[] currentVersion;

    public StructuredMemoryDataset(StructuredClassRegistry registry, StructuredObject root, byte[] currentVersion) {
        this.registry = registry;
        this.root = root;
        this.currentVersion = currentVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatasetSubscription connect(DatasetSubscriber subscriber) {
        List<Subscription> list = this.subscriptions;
        synchronized (list) {
            subscriber.onNewState(this.currentVersion, this.serializeState());
            Subscription subscription = new Subscription(subscriber);
            this.subscriptions.add(subscription);
            return subscription;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatasetSubscription connect(byte[] oldVersion, DatasetSubscriber subscriber) {
        List<Subscription> list = this.subscriptions;
        synchronized (list) {
            List<StructuredCommitHistoryItem> history = this.getHistorySince(oldVersion);
            if (history == null) {
                return this.connect(subscriber);
            }
            for (StructuredCommitHistoryItem operation : history) {
                subscriber.onUpdated(operation.id.bytes(), operation.commit);
            }
            Subscription subscription = new Subscription(subscriber);
            this.subscriptions.add(subscription);
            return subscription;
        }
    }

    private List<StructuredCommitHistoryItem> getHistorySince(byte[] oldVersion) {
        ByteString oldVersionByteString = new ByteString(oldVersion);
        if (!this.commitHistory.containsKey(oldVersionByteString)) {
            return null;
        }
        StructuredCommitHistoryItem item = this.commitHistory.get(oldVersionByteString);
        if (item.getNext() == null) {
            return Collections.emptyList();
        }
        ArrayList<StructuredCommitHistoryItem> result = new ArrayList<StructuredCommitHistoryItem>();
        for (item = item.getNext(); item != null; item = item.getNext()) {
            result.add(item);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publish(StructuredCommitHistoryItem operation) {
        List<Subscription> list = this.subscriptions;
        synchronized (list) {
            for (Subscription subscription : this.subscriptions) {
                subscription.subscriber.onUpdated(operation.id.bytes(), operation.commit);
            }
        }
    }

    private byte[] serializeState() {
        StructuredDataOutputStream scope = new StructuredDataOutputStream(this.registry, this);
        BytesDataOutput output = new BytesDataOutput();
        output.writeVarUInt(this.objects.size());
        for (StructuredObject object : this.objects) {
            object.serialize(scope, (DataOutput)output);
        }
        return output.toByteArray();
    }

    @Override
    public StructuredObject getObject(int id) {
        return id < 0 || id >= this.objects.size() ? null : this.objects.get(id);
    }

    @Override
    public int getId(StructuredObject object) {
        Integer result = this.idsByObject.get(object);
        return result == null ? -1 : result;
    }

    @Override
    public int addObject(StructuredObject object) {
        int id = this.objects.size();
        this.objects.add(object);
        this.idsByObject.put(object, id);
        return id;
    }

    private class Subscription
    implements DatasetSubscription {
        private final DatasetSubscriber subscriber;

        public Subscription(DatasetSubscriber subscriber) {
            this.subscriber = subscriber;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            List list = StructuredMemoryDataset.this.subscriptions;
            synchronized (list) {
                StructuredMemoryDataset.this.subscriptions.remove(this);
            }
        }
    }
}

