/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.entitysyncer.structured;

import java.util.HashMap;
import java.util.Map;
import org.openzen.entitysyncer.structured.StructuredField;
import org.openzen.entitysyncer.structured.StructuredObject;
import org.openzen.entitysyncer.structured.definition.StructuredFieldType;

public class StructuredObjectEditor {
    private final StructuredObject object;
    private final Map<Integer, StructuredField> updatedFields = new HashMap<Integer, StructuredField>();

    public StructuredObjectEditor(StructuredObject object) {
        this.object = object;
    }

    public void setInt(int field, int value) {
        this.updatedFields.put(field, this.getFieldType(field).getInt(value));
    }

    public void setLong(int field, long value) {
        this.updatedFields.put(field, this.getFieldType(field).getLong(value));
    }

    public void setFloat(int field, float value) {
        this.updatedFields.put(field, this.getFieldType(field).getFloat(value));
    }

    public void setDouble(int field, double value) {
        this.updatedFields.put(field, this.getFieldType(field).getDouble(value));
    }

    public void setString(int field, String value) {
        this.updatedFields.put(field, this.getFieldType(field).getString(value));
    }

    public void validate() {
    }

    private StructuredFieldType getFieldType(int field) {
        return this.object.getStructuredClass().getField((int)field).type;
    }
}

