/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.entitysyncer.structured.commit;

import org.openzen.entitysyncer.structured.StructuredDataset;
import org.openzen.entitysyncer.structured.StructuredObject;
import org.openzen.entitysyncer.structured.commit.StructuredOperation;
import org.openzen.entitysyncer.structured.value.IValue;
import org.openzen.packetstreams.io.DataInput;

public class StructuredSetOperation
implements StructuredOperation,
IValue {
    private final int object;
    private final int field;

    public StructuredSetOperation(int object, int field) {
        this.object = object;
        this.field = field;
    }

    public StructuredSetOperation(DataInput input) {
        this.object = input.readVarInt();
        this.field = input.readVarUInt();
    }

    @Override
    public void apply(StructuredDataset dataset) {
        StructuredObject object = dataset.getObject(this.object);
        if (object == null) {
            return;
        }
        object.setField(this.field, dataset, this);
    }

    @Override
    public boolean asBool() {
        throw new IllegalArgumentException("Cannot convert this value to a bool");
    }

    @Override
    public int asInt() {
        throw new IllegalArgumentException("Cannot convert this value to an int");
    }

    @Override
    public long asLong() {
        throw new IllegalArgumentException("Cannot convert this value to a long");
    }

    @Override
    public float asFloat() {
        throw new IllegalArgumentException("Cannot convert this value to a float");
    }

    @Override
    public double asDouble() {
        throw new IllegalArgumentException("Cannot convert this value to a double");
    }

    @Override
    public String asString() {
        throw new IllegalArgumentException("Cannot convert this value to a string");
    }

    @Override
    public int asObjectId() {
        throw new IllegalArgumentException("Cannot convert this value to an object");
    }
}

