/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.entitysyncer.structured.definition;

import org.openzen.entitysyncer.structured.StructuredDataInputStream;
import org.openzen.entitysyncer.structured.StructuredDataset;
import org.openzen.entitysyncer.structured.StructuredField;
import org.openzen.entitysyncer.structured.StructuredObject;
import org.openzen.entitysyncer.structured.definition.StructuredFieldType;
import org.openzen.entitysyncer.structured.fields.StructuredBoolField;
import org.openzen.entitysyncer.structured.value.IValue;
import org.openzen.packetstreams.io.DataInput;

public class BoolFieldType
implements StructuredFieldType {
    public static final BoolFieldType INSTANCE = new BoolFieldType();

    private BoolFieldType() {
    }

    @Override
    public StructuredField getBool(boolean value) {
        return new StructuredBoolField(value);
    }

    @Override
    public StructuredField getInt(int value) {
        return new StructuredBoolField(value != 0);
    }

    @Override
    public StructuredField getLong(long value) {
        return new StructuredBoolField(value != 0L);
    }

    @Override
    public StructuredField getFloat(float value) {
        throw new ClassCastException("Cannot convert a float to a bool");
    }

    @Override
    public StructuredField getDouble(double value) {
        throw new ClassCastException("Cannot convert a double to a bool");
    }

    @Override
    public StructuredField getString(String value) {
        return new StructuredBoolField(Boolean.parseBoolean(value));
    }

    @Override
    public StructuredField getObject(StructuredObject value) {
        throw new ClassCastException("Cannot convert an object to a bool");
    }

    @Override
    public StructuredField read(StructuredDataInputStream scope, DataInput input) {
        return new StructuredBoolField(input.readBoolean());
    }

    @Override
    public StructuredField get(StructuredDataset dataset, IValue value) {
        return new StructuredBoolField(value.asBool());
    }
}

