/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.entitysyncer.structured.definition;

import org.openzen.entitysyncer.structured.StructuredDataInputStream;
import org.openzen.entitysyncer.structured.StructuredDataset;
import org.openzen.entitysyncer.structured.StructuredField;
import org.openzen.entitysyncer.structured.StructuredObject;
import org.openzen.entitysyncer.structured.definition.StructuredFieldType;
import org.openzen.entitysyncer.structured.fields.StructuredFloatField;
import org.openzen.entitysyncer.structured.value.IValue;
import org.openzen.packetstreams.io.DataInput;

public class FloatFieldType
implements StructuredFieldType {
    public static final FloatFieldType INSTANCE = new FloatFieldType();

    private FloatFieldType() {
    }

    @Override
    public StructuredField getBool(boolean value) {
        return new StructuredFloatField(value ? 1.0f : 0.0f);
    }

    @Override
    public StructuredField getInt(int value) {
        return new StructuredFloatField(value);
    }

    @Override
    public StructuredField getLong(long value) {
        return new StructuredFloatField(value);
    }

    @Override
    public StructuredField getFloat(float value) {
        return new StructuredFloatField(value);
    }

    @Override
    public StructuredField getDouble(double value) {
        return new StructuredFloatField((float)value);
    }

    @Override
    public StructuredField getString(String value) {
        return new StructuredFloatField(Float.parseFloat(value));
    }

    @Override
    public StructuredField getObject(StructuredObject value) {
        throw new ClassCastException("Cannot convert object to float");
    }

    @Override
    public StructuredField read(StructuredDataInputStream scope, DataInput input) {
        return new StructuredFloatField(input.readFloat());
    }

    @Override
    public StructuredField get(StructuredDataset dataset, IValue value) {
        return new StructuredFloatField(value.asFloat());
    }
}

