/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.entitysyncer.structured.definition;

import org.openzen.entitysyncer.structured.StructuredDataInputStream;
import org.openzen.entitysyncer.structured.StructuredDataset;
import org.openzen.entitysyncer.structured.StructuredField;
import org.openzen.entitysyncer.structured.StructuredObject;
import org.openzen.entitysyncer.structured.definition.StructuredFieldType;
import org.openzen.entitysyncer.structured.fields.StructuredLongField;
import org.openzen.entitysyncer.structured.value.IValue;
import org.openzen.packetstreams.io.DataInput;

public class LongFieldType
implements StructuredFieldType {
    public static final LongFieldType INSTANCE = new LongFieldType();

    private LongFieldType() {
    }

    @Override
    public StructuredField getBool(boolean value) {
        return new StructuredLongField(value ? 1L : 0L);
    }

    @Override
    public StructuredField getInt(int value) {
        return new StructuredLongField(value);
    }

    @Override
    public StructuredField getLong(long value) {
        return new StructuredLongField(value);
    }

    @Override
    public StructuredField getFloat(float value) {
        return new StructuredLongField((long)value);
    }

    @Override
    public StructuredField getDouble(double value) {
        return new StructuredLongField((long)value);
    }

    @Override
    public StructuredField getString(String value) {
        return new StructuredLongField(Long.parseLong(value));
    }

    @Override
    public StructuredField getObject(StructuredObject value) {
        throw new ClassCastException("Cannot convert object to long");
    }

    @Override
    public StructuredField read(StructuredDataInputStream scope, DataInput input) {
        return new StructuredLongField(input.readVarLong());
    }

    @Override
    public StructuredField get(StructuredDataset dataset, IValue value) {
        return new StructuredLongField(value.asLong());
    }
}

