/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.entitysyncer.structured.definition;

import org.openzen.entitysyncer.structured.StructuredDataInputStream;
import org.openzen.entitysyncer.structured.StructuredDataset;
import org.openzen.entitysyncer.structured.StructuredField;
import org.openzen.entitysyncer.structured.StructuredObject;
import org.openzen.entitysyncer.structured.definition.StructuredFieldType;
import org.openzen.entitysyncer.structured.fields.StructuredStringField;
import org.openzen.entitysyncer.structured.value.IValue;
import org.openzen.packetstreams.io.DataInput;

public class StringFieldType
implements StructuredFieldType {
    public static final StringFieldType INSTANCE = new StringFieldType();

    private StringFieldType() {
    }

    @Override
    public StructuredField getBool(boolean value) {
        return new StructuredStringField(Boolean.toString(value));
    }

    @Override
    public StructuredField getInt(int value) {
        return new StructuredStringField(Integer.toString(value));
    }

    @Override
    public StructuredField getLong(long value) {
        return new StructuredStringField(Long.toString(value));
    }

    @Override
    public StructuredField getFloat(float value) {
        return new StructuredStringField(Float.toString(value));
    }

    @Override
    public StructuredField getDouble(double value) {
        return new StructuredStringField(Double.toString(value));
    }

    @Override
    public StructuredField getString(String value) {
        return new StructuredStringField(value);
    }

    @Override
    public StructuredField getObject(StructuredObject value) {
        throw new ClassCastException("Cannot cast object to string");
    }

    @Override
    public StructuredField read(StructuredDataInputStream scope, DataInput input) {
        return new StructuredStringField(input.readString());
    }

    @Override
    public StructuredField get(StructuredDataset dataset, IValue value) {
        return new StructuredStringField(value.asString());
    }
}

