/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured;

import java.util.List;
import org.openzen.entitysyncer.structured.definition.StructuredFieldDefinition;
import org.openzen.entitysyncer.structured.definition.StructuredObjectClass;
import org.openzen.entitysyncer.live.field.LiveField;

/**
 *
 * @author Hoofdgebruiker
 */
public class StructuredGenericObject implements StructuredObject {
	private final StructuredObject baseObject;
	private final StructuredObjectClass cls;
	private List<LiveField> fields;
	
	public StructuredGenericObject(StructuredObject baseObject, StructuredObjectClass cls, StructuredDataInputStream input) {
		this.baseObject = baseObject;
		this.cls = cls;
		
		for (StructuredFieldDefinition field : cls.getFields()) {
			while (field.id <= fields.size())
				fields.add(null);
			
			fields.set(field.id, field.type.create());
		}
		
		long fieldsMask = input.input.readVarULong();
		int index = 0;
		for (StructuredFieldDefinition field : cls.getFields()) {
			long fieldMask = 1L << index;
			if ((fieldsMask & fieldMask) > 0) {
				fieldsMask &= ~fieldMask;
				field.type.read(fields.get(field.id), input);
			}
			
			index++;
		}
		
		if (fieldsMask != 0) {
			throw new RuntimeException("Illegal object: one or more fields were not deserialized");
		}
	}

	@Override
	public StructuredObjectClass getStructuredClass() {
		return cls;
	}
	
	@Override
	public StructuredObject getBaseObject() {
		return baseObject;
	}

	@Override
	public LiveField getField(int index) {
		return fields.get(index);
	}

	@Override
	public <T extends StructuredObject> T as(Class<T> cls) {
		return baseObject == null ? null : baseObject.as(cls);
	}
}
