/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured.commit;

import org.openzen.entitysyncer.structured.StructuredDataInputStream;
import org.openzen.entitysyncer.live.field.LiveField;

/**
 *
 * @author Hoofdgebruiker
 */
public class SetFloatFieldOperation extends StructuredSetOperation {
	private final float value;
	
	public SetFloatFieldOperation(int object, int field, float value) {
		super(object, field);
		
		this.value = value;
	}
	
	public SetFloatFieldOperation(StructuredDataInputStream input) {
		super(input);
		
		this.value = input.input.readFloat();
	}

	@Override
	protected void apply(LiveField field) {
		field.asFloat().set(value);
	}
}
