/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured.definition;

import java.util.List;
import java.util.UUID;
import org.openzen.entitysyncer.live.LiveObjectList;
import org.openzen.entitysyncer.live.any.LiveAny;
import org.openzen.entitysyncer.live.field.LiveField;
import org.openzen.entitysyncer.live.field.LiveObjectListField;
import org.openzen.entitysyncer.structured.StructuredDataInputStream;
import org.openzen.entitysyncer.structured.StructuredDataOutputStream;

/**
 *
 * @author Hoofdgebruiker
 */
public class ObjectListFieldType implements StructuredFieldType {
	public final UUID clsid;
	
	public ObjectListFieldType(UUID clsid) {
		this.clsid = clsid;
	}

	@Override
	public LiveField create() {
		return new LiveObjectListField(this);
	}

	@Override
	public void serialize(StructuredDataOutputStream output) {
		output.output.writeVarUInt(TYPE_OBJECTLIST);
		output.output.writeUUID(clsid);
	}

	@Override
	public void read(LiveField field, StructuredDataInputStream input) {
		int numObjects = input.input.readVarUInt();
		LiveObjectList objects = field.asObjectList();
		for (int i = 0; i < numObjects; i++) {
			objects.add(input.readStructuredObject());
		}
	}

	@Override
	public void write(StructuredDataOutputStream output, LiveAny value) {
		List<?> objects = value.asObjectList().get();
		
	}
}
