/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured.definition;

import java.util.UUID;
import org.openzen.entitysyncer.live.any.LiveAny;
import org.openzen.entitysyncer.live.any.LiveStruct;
import org.openzen.entitysyncer.live.field.LiveField;
import org.openzen.entitysyncer.structured.StructuredDataInputStream;
import org.openzen.entitysyncer.structured.StructuredDataOutputStream;

/**
 *
 * @author Hoofdgebruiker
 */
public abstract class StructFieldType<T extends LiveStruct> implements StructuredFieldType {
	public final UUID id;
	public final Class<T> cls;
	
	public StructFieldType(UUID id, Class<T> cls) {
		this.id = id;
		this.cls = cls;
	}
	
	public abstract void read(T value, StructuredDataInputStream input);

	public abstract void write(T value, StructuredDataOutputStream output);
	
	@Override
	public final void read(LiveField field, StructuredDataInputStream input) {
		read(field.asStruct(cls), input);
	}

	@Override
	public final void serialize(StructuredDataOutputStream output) {
		output.output.writeVarUInt(TYPE_STRUCT);
		output.output.writeUUID(id);
	}

	@Override
	public final void write(StructuredDataOutputStream output, LiveAny value) {
		write(value.asStruct(cls), output);
	}
}
