/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.live;

/**
 *
 * @author Hoofdgebruiker
 */
public class SubscribableList<T> extends Subscribable {
	// implements a linked list of nodes
	private volatile ListListenerNode firstListListener = null;
	private ListListenerNode lastListListener = null;

	/**
	 * Adds an IEventListener to the list.
	 *
	 * @param listener event listener
	 * @return event listener's handle
	 */
	public LiveSubscription subscribe(LiveListListener listener)
	{
        return subscribe(listener, PRIORITY_DEFAULT);
    }

    public LiveSubscription subscribe(LiveListListener listener, int priority)
	{
		ListListenerNode node = new ListListenerNode(listener, priority);
		
		synchronized (this) {
			if (firstListListener == null) {
				firstListListener = lastListListener = node;
			} else {
                // prioritized list: where to insert?
                ListListenerNode previousNode = lastListListener;
                while (previousNode != null && priority > previousNode.priority) {
                    previousNode = previousNode.prev;
                }

                if (previousNode == null) {
                    node.next = firstListListener;
                    firstListListener.prev = previousNode;
                    firstListListener = node;
                } else {
                    if (previousNode.next == null) {
                        lastListListener = node;
                    } else {
                        previousNode.next.prev = node;
                    }

                    previousNode.next = node;
                    node.prev = previousNode;
                }
            }
		}

		return node;
	}
	
	protected void publishInserted(int index, T value)
	{
		ListListenerNode current = firstListListener;
		
		while (current != null) {
			current.listener.onInserted(index, value);
			current = current.next;
		}
	}
	
	protected void publishUpdated(int index, T oldValue, T newValue)
	{
		ListListenerNode current = firstListListener;
		
		while (current != null) {
			current.listener.onUpdated(index, oldValue, newValue);
			current = current.next;
		}
	}
	
	protected void publishRemoved(int index, T value)
	{
		ListListenerNode current = firstListListener;
		
		while (current != null) {
			current.listener.onRemoved(index, value);
			current = current.next;
		}
	}

	// =======================
	// === Private classes ===
	// =======================

	protected class ListListenerNode implements LiveSubscription
	{
		protected final LiveListListener<T> listener;
        protected final int priority;
		protected ListListenerNode next = null;
		protected ListListenerNode prev = null;

		public ListListenerNode(LiveListListener<T> listener, int priority)
		{
			this.listener = listener;
            this.priority = priority;
		}

		@Override
		public void close()
		{
			synchronized (SubscribableList.this) {
				if (prev == null) {
					firstListListener = next;
				} else {
					prev.next = next;
				}

				if (next == null) {
					lastListListener = prev;
				} else {
					next.prev = prev;
				}
			}
		}
	}
}
