/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.openzen.entitysyncer.structured.definition.StructFieldType;
import org.openzen.entitysyncer.structured.definition.StructuredObjectClass;

/**
 *
 * @author Hoofdgebruiker
 */
public class StructuredClassRegistry {
	private final Map<UUID, StructuredClassEntry<?>> entriesByUUID = new HashMap<>();
	private final Map<Class<?>, StructuredClassEntry<?>> entriesByClass = new HashMap<>();
	private final Map<UUID, StructFieldType<?>> structTypes = new HashMap<>();
	
	public <T extends StructuredObject> void register(Class<T> cls, StructuredObjectClass objectClass, StructuredClassFactory<T> factory) {
		if (objectClass.superclassId != null) {
			StructuredClassEntry<?> superclassEntry = entriesByUUID.get(objectClass.superclassId);
			if (superclassEntry == null)
				throw new IllegalArgumentException("Superclass is not yet registered! Make sure to register the superclass first.");
		}
		
		StructuredClassEntry<T> entry = new StructuredClassEntry<>(objectClass.id, objectClass.superclassId, cls, factory);
		entriesByUUID.put(objectClass.id, entry);
		entriesByClass.put(cls, entry);
	}
	
	public void register(StructuredObjectClass objectClass) {
		StructuredClassEntry<?> superclassEntry = null;
		if (objectClass.superclassId != null) {
			superclassEntry = entriesByUUID.get(objectClass.superclassId);
			if (superclassEntry == null)
				throw new IllegalArgumentException("Superclass is not yet registered! Make sure to register the superclass first.");
		}
		
		StructuredClassEntry entry = new StructuredClassEntry<>(objectClass.id, objectClass.superclassId, null, new GenericFactory(superclassEntry, objectClass));
		entriesByUUID.put(objectClass.id, entry);
	}
	
	public void register(StructFieldType<?> type) {
		structTypes.put(type.id, type);
	}
	
	public boolean knows(UUID uuid) {
		return !entriesByUUID.containsKey(uuid);
	}
	
	public StructuredObject read(UUID clsid, StructuredDataInputStream input) {
		return entriesByUUID.get(clsid).factory.read(input);
	}
	
	public StructFieldType<?> getStructType(UUID id) {
		return structTypes.get(id);
	}
	
	private class StructuredClassEntry<T extends StructuredObject> {
		public final UUID id;
		public final UUID superclassId;
		public final Class<T> cls;
		public final StructuredClassFactory<T> factory;
		
		private StructuredClassEntry(UUID id, UUID superclassId, Class<T> cls, StructuredClassFactory<T> factory) {
			this.id = id;
			this.superclassId = superclassId;
			this.cls = cls;
			this.factory = factory;
		}
	}
	
	private class GenericFactory implements StructuredClassFactory<StructuredGenericObject> {
		private final StructuredClassEntry<?> superEntry;
		private final StructuredObjectClass definition;
		
		public GenericFactory(StructuredClassEntry<?> superEntry, StructuredObjectClass definition) {
			this.superEntry = superEntry;
			this.definition = definition;
		}

		@Override
		public StructuredGenericObject read(StructuredDataInputStream input) {
			return new StructuredGenericObject(definition, input);
		}
	}
}
