/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured.definition;

import org.openzen.entitysyncer.live.any.LiveAny;
import org.openzen.entitysyncer.live.field.LiveBoolField;
import org.openzen.entitysyncer.structured.StructuredDataInputStream;
import org.openzen.entitysyncer.structured.StructuredDataOutputStream;
import org.openzen.entitysyncer.live.field.LiveField;

/**
 *
 * @author Hoofdgebruiker
 */
public class BoolFieldType implements StructuredFieldType {
	public static final BoolFieldType INSTANCE = new BoolFieldType();
	
	private BoolFieldType() {}

	@Override
	public void serialize(StructuredDataOutputStream output) {
		output.output.writeVarUInt(TYPE_BOOL);
	}
	
	@Override
	public LiveField create() {
		return new LiveBoolField();
	}

	@Override
	public void read(LiveField field, StructuredDataInputStream input) {
		field.asBool().set(input.input.readBoolean());
	}
	
	@Override
	public void write(StructuredDataOutputStream stream, LiveAny value) {
		stream.output.writeBoolean(value.asBoolValue());
	}
}
