/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.entitysyncer.live.field;

import java.util.UUID;
import org.openzen.entitysyncer.live.LiveObject;
import org.openzen.entitysyncer.live.LiveString;
import org.openzen.entitysyncer.live.LiveUUID;
import org.openzen.entitysyncer.live.LiveUUIDFunction;
import org.openzen.entitysyncer.live.field.LiveBaseNumberField;
import org.openzen.entitysyncer.structured.StructuredObject;
import org.openzen.entitysyncer.structured.definition.StringFieldType;
import org.openzen.entitysyncer.structured.definition.StructuredFieldType;

public class LiveStringField
extends LiveBaseNumberField
implements LiveString {
    private String value;

    public LiveStringField() {
        this.value = "";
    }

    public LiveStringField(String value) {
        this.value = value;
    }

    @Override
    public void clear() {
        this.set("");
    }

    @Override
    public StructuredFieldType getType() {
        return StringFieldType.INSTANCE;
    }

    @Override
    public String get() {
        return this.value;
    }

    @Override
    public void set(String value) {
        this.value = value;
        this.publish();
    }

    @Override
    public boolean asBoolValue() {
        return Boolean.parseBoolean(this.value);
    }

    @Override
    public int asIntValue() {
        return Integer.parseInt(this.value);
    }

    @Override
    public long asLongValue() {
        return Long.parseLong(this.value);
    }

    @Override
    public float asFloatValue() {
        return Float.parseFloat(this.value);
    }

    @Override
    public double asDoubleValue() {
        return Double.parseDouble(this.value);
    }

    @Override
    public LiveString asString() {
        return this;
    }

    @Override
    public String asStringValue() {
        return this.value;
    }

    @Override
    public LiveUUID asUUID() {
        return new LiveUUIDFunction(this::asUUIDValue, this);
    }

    @Override
    public UUID asUUIDValue() {
        return UUID.fromString(this.value);
    }

    @Override
    public LiveObject<?> asObject() {
        throw new ClassCastException("Cannot convert a string to an object");
    }

    @Override
    public StructuredObject asObjectValue() {
        throw new ClassCastException("Cannot convert a string to an object");
    }
}

