/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.entitysyncer.structured;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.openzen.entitysyncer.live.field.LiveField;
import org.openzen.entitysyncer.structured.StructuredDataInputStream;
import org.openzen.entitysyncer.structured.StructuredObject;
import org.openzen.entitysyncer.structured.definition.StructuredFieldDefinition;
import org.openzen.entitysyncer.structured.definition.StructuredObjectClass;

public class StructuredGenericObject
implements StructuredObject {
    private final StructuredObjectClass cls;
    private final ObjectFields fields;

    public StructuredGenericObject(StructuredObjectClass cls, StructuredDataInputStream input) {
        this.cls = cls;
        this.fields = StructuredGenericObject.read(cls, input);
    }

    @Override
    public StructuredObjectClass getStructuredClass() {
        return this.cls;
    }

    @Override
    public LiveField getField(UUID cls, int index) {
        return this.fields.get(cls, index);
    }

    private static ObjectFields read(StructuredObjectClass cls, StructuredDataInputStream input) {
        ArrayList<LiveField> fields = new ArrayList<LiveField>();
        for (StructuredFieldDefinition field : cls.getFields()) {
            while (field.id <= fields.size()) {
                fields.add(null);
            }
            fields.set(field.id, field.type.create());
        }
        long fieldsMask = input.input.readVarULong();
        int index = 0;
        for (StructuredFieldDefinition field : cls.getFields()) {
            long fieldMask = 1L << index;
            if ((fieldsMask & fieldMask) > 0L) {
                fieldsMask &= fieldMask ^ 0xFFFFFFFFFFFFFFFFL;
                field.type.read((LiveField)fields.get(field.id), input);
            }
            ++index;
        }
        if (fieldsMask != 0L) {
            throw new RuntimeException("Illegal object: one or more fields were not deserialized");
        }
        return new ObjectFields(cls.id, fields, null);
    }

    private static class ObjectFields {
        private final UUID cls;
        private final List<LiveField> fields;
        private final ObjectFields parent;

        public ObjectFields(UUID cls, List<LiveField> fields, ObjectFields parent) {
            this.cls = cls;
            this.fields = fields;
            this.parent = parent;
        }

        public LiveField get(UUID cls, int field) {
            if (!cls.equals(this.cls)) {
                if (this.parent != null) {
                    throw new IllegalArgumentException("Unknown field: " + cls + "::" + field);
                }
                return this.parent.get(cls, field);
            }
            if (field >= this.fields.size() || this.fields.get(field) == null) {
                throw new IllegalArgumentException("Unknown field: " + cls + "::" + field);
            }
            return this.fields.get(field);
        }
    }
}

