/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.live;

/**
 *
 * @author Hoofdgebruiker
 */
public class LiveLongFunction implements LiveLong {
	private final Function function;
	private final ReverseFunction reverse;
	private final LiveValue source;
	
	public LiveLongFunction(Function function, LiveValue source) {
		this.function = function;
		this.reverse = null;
		this.source = source;
	}
	
	public LiveLongFunction(Function function, ReverseFunction reverse, LiveValue source) {
		this.function = function;
		this.reverse = reverse;
		this.source = source;
	}

	@Override
	public long get() {
		return function.get();
	}
	
	@Override
	public void clear() {
		if (reverse == null)
			throw new UnsupportedOperationException("Object cannot be modified");
		
		source.clear();
	}
	
	@Override
	public void set(long value) {
		if (reverse == null)
			throw new UnsupportedOperationException("Object cannot be modified");
		
		reverse.set(value);
	}

	@Override
	public LiveSubscription subscribe(LiveListener listener) {
		return source.subscribe(listener);
	}
	
	public interface Function {
		long get();
	}
	
	public interface ReverseFunction {
		void set(long value);
	}
}
