/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.server;

import java.util.List;
import java.util.UUID;
import org.openzen.entitysyncer.datasets.DatasetProvider;
import org.openzen.packetstreams.PacketStreamService;
import org.openzen.packetstreams.ServiceStream;
import org.openzen.packetstreams.crypto.CryptoPublicKey;
import org.openzen.packetstreams.io.BytesDataOutput;

/**
 *
 * @author Hoofdgebruiker
 */
public class EntitySyncerServer implements PacketStreamService {
	public static final UUID SERVICE_UUID = UUID.fromString("63ed8cfc-d2fc-467d-b39a-db9100508f83");
	
	private final byte[] info;
	private final List<DatasetProvider> providers;
	
	public EntitySyncerServer(List<DatasetProvider> providers) {
		this.providers = providers;
		
		BytesDataOutput infoOutput = new BytesDataOutput();
		infoOutput.writeVarUInt(1);
		infoOutput.writeVarUInt(providers.size());
		for (DatasetProvider provider : providers) {
			infoOutput.writeString(provider.getType());
		}
		info = infoOutput.toByteArray();
	}

	@Override
	public UUID getUUID() {
		return SERVICE_UUID;
	}

	@Override
	public byte[] getInfo() {
		return info;
	}

	@Override
	public ServiceStream connect(CryptoPublicKey publicKey, byte[] bytes) {
		return new EntitySyncerServerStream(providers, publicKey);
	}
}
