/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured.commit;

import java.util.UUID;
import org.openzen.entitysyncer.structured.StructuredDataInputStream;
import org.openzen.entitysyncer.live.field.LiveField;

/**
 *
 * @author Hoofdgebruiker
 */
public class SetDoubleFieldOperation extends StructuredSetOperation {
	private final double value;
	
	public SetDoubleFieldOperation(int object, UUID type, int field, double value) {
		super(object, type, field);
		
		this.value = value;
	}
	
	public SetDoubleFieldOperation(StructuredDataInputStream input) {
		super(input);
		
		value = input.input.readDouble();
	}

	@Override
	protected void apply(LiveField field) {
		field.asDouble().set(value);
	}
}
