/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.entitysyncer.live;

import org.openzen.entitysyncer.live.LiveListListener;
import org.openzen.entitysyncer.live.LiveSubscription;
import org.openzen.entitysyncer.live.Subscribable;

public class SubscribableList<T>
extends Subscribable {
    private volatile ListListenerNode firstListListener = null;
    private ListListenerNode lastListListener = null;

    public LiveSubscription subscribe(LiveListListener listener) {
        return this.subscribe(listener, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiveSubscription subscribe(LiveListListener listener, int priority) {
        ListListenerNode node = new ListListenerNode(listener, priority);
        SubscribableList subscribableList = this;
        synchronized (subscribableList) {
            if (this.firstListListener == null) {
                this.firstListListener = this.lastListListener = node;
            } else {
                ListListenerNode previousNode = this.lastListListener;
                while (previousNode != null && priority > previousNode.priority) {
                    previousNode = previousNode.prev;
                }
                if (previousNode == null) {
                    node.next = this.firstListListener;
                    this.firstListListener.prev = previousNode;
                    this.firstListListener = node;
                } else {
                    if (previousNode.next == null) {
                        this.lastListListener = node;
                    } else {
                        previousNode.next.prev = node;
                    }
                    previousNode.next = node;
                    node.prev = previousNode;
                }
            }
        }
        return node;
    }

    protected void publishInserted(int index, T value) {
        ListListenerNode current = this.firstListListener;
        while (current != null) {
            current.listener.onInserted(index, value);
            current = current.next;
        }
    }

    protected void publishUpdated(int index, T oldValue, T newValue) {
        ListListenerNode current = this.firstListListener;
        while (current != null) {
            current.listener.onUpdated(index, oldValue, newValue);
            current = current.next;
        }
    }

    protected void publishRemoved(int index, T value) {
        ListListenerNode current = this.firstListListener;
        while (current != null) {
            current.listener.onRemoved(index, value);
            current = current.next;
        }
    }

    protected class ListListenerNode
    implements LiveSubscription {
        protected final LiveListListener<T> listener;
        protected final int priority;
        protected ListListenerNode next = null;
        protected ListListenerNode prev = null;

        public ListListenerNode(LiveListListener<T> listener, int priority) {
            this.listener = listener;
            this.priority = priority;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            SubscribableList subscribableList = SubscribableList.this;
            synchronized (subscribableList) {
                if (this.prev == null) {
                    SubscribableList.this.firstListListener = this.next;
                } else {
                    this.prev.next = this.next;
                }
                if (this.next == null) {
                    SubscribableList.this.lastListListener = this.prev;
                } else {
                    this.next.prev = this.prev;
                }
            }
        }
    }
}

