/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.entitysyncer.structured.commit;

import java.util.ArrayList;
import java.util.List;
import org.openzen.entitysyncer.structured.StructuredDataInputStream;
import org.openzen.entitysyncer.structured.commit.SetBoolFieldOperation;
import org.openzen.entitysyncer.structured.commit.SetDoubleFieldOperation;
import org.openzen.entitysyncer.structured.commit.SetFloatFieldOperation;
import org.openzen.entitysyncer.structured.commit.SetIntFieldOperation;
import org.openzen.entitysyncer.structured.commit.SetLongFieldOperation;
import org.openzen.entitysyncer.structured.commit.SetObjectFieldOperation;
import org.openzen.entitysyncer.structured.commit.SetStringFieldOperation;
import org.openzen.entitysyncer.structured.commit.StructuredOperation;

public class StructuredCommit {
    public static final int OP_END = 0;
    public static final int OP_SET_FIELD_BOOL_TRUE = 16;
    public static final int OP_SET_FIELD_BOOL_FALSE = 17;
    public static final int OP_SET_FIELD_INT = 18;
    public static final int OP_SET_FIELD_LONG = 19;
    public static final int OP_SET_FIELD_FLOAT = 20;
    public static final int OP_SET_FIELD_DOUBLE = 21;
    public static final int OP_SET_FIELD_STRING = 22;
    public static final int OP_SET_FIELD_OBJECT = 23;
    private final List<StructuredOperation> operations;

    public StructuredCommit(List<StructuredOperation> operations) {
        this.operations = operations;
    }

    public StructuredCommit(StructuredDataInputStream input) {
        this.operations = new ArrayList<StructuredOperation>();
        int op = input.input.readVarUInt();
        while (op != 0) {
            switch (op) {
                case 16: {
                    this.operations.add(new SetBoolFieldOperation(input, true));
                    break;
                }
                case 18: {
                    this.operations.add(new SetIntFieldOperation(input));
                    break;
                }
                case 19: {
                    this.operations.add(new SetLongFieldOperation(input));
                    break;
                }
                case 20: {
                    this.operations.add(new SetFloatFieldOperation(input));
                    break;
                }
                case 21: {
                    this.operations.add(new SetDoubleFieldOperation(input));
                    break;
                }
                case 22: {
                    this.operations.add(new SetStringFieldOperation(input));
                    break;
                }
                case 23: {
                    this.operations.add(new SetObjectFieldOperation(input));
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown operation: " + op);
                }
            }
            op = input.input.readVarUInt();
        }
    }
}

