/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.live.field;

import java.util.UUID;
import org.openzen.entitysyncer.live.LiveBool;
import org.openzen.entitysyncer.live.LiveByteArray;
import org.openzen.entitysyncer.live.LiveDouble;
import org.openzen.entitysyncer.live.LiveFloat;
import org.openzen.entitysyncer.live.LiveInt;
import org.openzen.entitysyncer.live.LiveLong;
import org.openzen.entitysyncer.live.LiveObject;
import org.openzen.entitysyncer.live.LiveObjectList;
import org.openzen.entitysyncer.live.LiveString;
import org.openzen.entitysyncer.live.LiveUUID;
import org.openzen.entitysyncer.live.Subscribable;
import org.openzen.entitysyncer.live.any.LiveStruct;
import org.openzen.entitysyncer.structured.StructuredObject;

/**
 *
 * @author Hoofdgebruiker
 */
public abstract class LiveBaseField extends Subscribable implements LiveField {

	@Override
	public LiveBool asBool() {
		throw new ClassCastException("Cannot convert " + getType() + " to bool");
	}

	@Override
	public boolean asBoolValue() {
		throw new ClassCastException("Cannot convert " + getType() + " to bool");
	}

	@Override
	public LiveInt asInt() {
		throw new ClassCastException("Cannot convert " + getType() + " to int");
	}

	@Override
	public int asIntValue() {
		throw new ClassCastException("Cannot convert " + getType() + " to int");
	}

	@Override
	public LiveLong asLong() {
		throw new ClassCastException("Cannot convert " + getType() + " to long");
	}

	@Override
	public long asLongValue() {
		throw new ClassCastException("Cannot convert " + getType() + " to long");
	}

	@Override
	public LiveFloat asFloat() {
		throw new ClassCastException("Cannot convert " + getType() + " to float");
	}

	@Override
	public float asFloatValue() {
		throw new ClassCastException("Cannot convert " + getType() + " to float");
	}

	@Override
	public LiveDouble asDouble() {
		throw new ClassCastException("Cannot convert " + getType() + " to double");
	}

	@Override
	public double asDoubleValue() {
		throw new ClassCastException("Cannot convert " + getType() + " to double");
	}

	@Override
	public LiveString asString() {
		throw new ClassCastException("Cannot convert " + getType() + " to string");
	}

	@Override
	public String asStringValue() {
		throw new ClassCastException("Cannot convert " + getType() + " to string");
	}
	
	@Override
	public LiveUUID asUUID() {
		throw new ClassCastException("Cannot convert " + getType() + " to uuid");
	}
	
	@Override
	public UUID asUUIDValue() {
		throw new ClassCastException("Cannot convert " + getType() + " to uuid");
	}
	
	@Override
	public LiveByteArray asByteArray() {
		throw new ClassCastException("Cannot convert " + getType() + " to byte[]");
	}
	
	@Override
	public byte[] asByteArrayValue() {
		throw new ClassCastException("Cannot convert " + getType() + " to byte[]");
	}

	@Override
	public LiveObject<?> asObject() {
		throw new ClassCastException("Cannot convert " + getType() + " to object");
	}

	@Override
	public StructuredObject asObjectValue() {
		throw new ClassCastException("Cannot convert " + getType() + " to object");
	}

	@Override
	public LiveObjectList<?> asObjectList() {
		throw new ClassCastException("Cannot convert " + getType() + " to object list");
	}
	
	@Override
	public <T extends LiveStruct> T asStruct(Class<T> cls) {
		throw new ClassCastException("Cannot convert " + getType() + " to a struct");
	}
}
