/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured.commit;

import java.util.UUID;
import org.openzen.entitysyncer.structured.StructuredDataInputStream;
import org.openzen.entitysyncer.structured.StructuredObject;
import org.openzen.entitysyncer.live.field.LiveField;

/**
 *
 * @author Hoofdgebruiker
 */
public class SetObjectFieldOperation extends StructuredSetOperation {
	private final StructuredObject value;
	
	public SetObjectFieldOperation(int object, UUID type, int field, StructuredObject value) {
		super(object, type, field);
		
		this.value = value;
	}
	
	public SetObjectFieldOperation(StructuredDataInputStream input) {
		super(input);
		
		value = input.readStructuredObject();
	}

	@Override
	protected void apply(LiveField field) {
		field.asObject().setUnsafe(value);
	}
}
