/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured.commit;

import java.util.UUID;
import org.openzen.entitysyncer.structured.StructuredDataInputStream;
import org.openzen.entitysyncer.structured.StructuredDataset;
import org.openzen.entitysyncer.structured.StructuredObject;
import org.openzen.entitysyncer.live.field.LiveField;

/**
 *
 * @author Hoofdgebruiker
 */
public abstract class StructuredSetOperation implements StructuredOperation {
	protected final int object;
	protected final UUID type;
	protected final int field;
	
	public StructuredSetOperation(int object, UUID type, int field) {
		this.object = object;
		this.type = type;
		this.field = field;
	}
	
	public StructuredSetOperation(StructuredDataInputStream input) {
		object = input.input.readVarInt();
		type = input.input.readUUID();
		field = input.input.readVarUInt();
	}

	@Override
	public void apply(StructuredDataset dataset) {
		StructuredObject object = dataset.getObject(this.object);
		if (object == null)
			return; // ignore operation on deleted object
		
		apply(object.getField(type, field));
	}
	
	protected abstract void apply(LiveField field);
}
