/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured.definition;

import org.openzen.entitysyncer.live.any.LiveAny;
import org.openzen.entitysyncer.live.field.LiveByteArrayField;
import org.openzen.entitysyncer.live.field.LiveField;
import org.openzen.entitysyncer.structured.StructuredDataInputStream;
import org.openzen.entitysyncer.structured.StructuredDataOutputStream;

/**
 *
 * @author Hoofdgebruiker
 */
public class ByteArrayFieldType implements StructuredFieldType {
	public static final ByteArrayFieldType INSTANCE = new ByteArrayFieldType();
	
	private ByteArrayFieldType() {}

	@Override
	public LiveField create() {
		return new LiveByteArrayField();
	}

	@Override
	public void serialize(StructuredDataOutputStream output) {
		output.output.writeVarUInt(TYPE_BYTEARRAY);
	}

	@Override
	public void read(LiveField field, StructuredDataInputStream input) {
		field.asByteArray().set(input.input.readByteArray());
	}

	@Override
	public void write(StructuredDataOutputStream output, LiveAny value) {
		output.output.writeByteArray(value.asByteArrayValue());
	}
}
