/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured.definition;

import org.openzen.entitysyncer.live.any.LiveAny;
import org.openzen.entitysyncer.structured.StructuredDataInputStream;
import org.openzen.entitysyncer.structured.StructuredDataOutputStream;
import org.openzen.entitysyncer.live.field.LiveField;
import org.openzen.entitysyncer.live.field.LiveFloatField;

/**
 *
 * @author Hoofdgebruiker
 */
public class FloatFieldType implements StructuredFieldType {
	public static final FloatFieldType INSTANCE = new FloatFieldType();
	
	private FloatFieldType() {}

	@Override
	public void serialize(StructuredDataOutputStream output) {
		output.output.writeVarUInt(TYPE_FLOAT);
	}

	@Override
	public LiveField create() {
		return new LiveFloatField();
	}

	@Override
	public void read(LiveField field, StructuredDataInputStream input) {
		field.asFloat().set(input.input.readFloat());
	}

	@Override
	public void write(StructuredDataOutputStream output, LiveAny value) {
		output.output.writeFloat(value.asFloatValue());
	}
}
