/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.structured.definition;

import java.util.UUID;
import org.openzen.entitysyncer.structured.StructuredDataInputStream;
import org.openzen.entitysyncer.live.field.LiveField;
import org.openzen.entitysyncer.structured.StructuredDataOutputStream;

/**
 *
 * @author Hoofdgebruiker
 */
public class StructuredFieldDefinition {
	public final int id;
	public final String name;
	public final StructuredFieldType type;
	
	public StructuredFieldDefinition(int id, String name, StructuredFieldType type) {
		this.id = id;
		this.name = name;
		this.type = type;
	}
	
	public StructuredFieldDefinition(StructuredDataInputStream input) {
		id = input.input.readVarUInt();
		name = input.input.readString();
		type = readType(input);
	}
	
	public void read(LiveField field, StructuredDataInputStream input) {
		type.read(field, input);
	}
	
	private static StructuredFieldType readType(StructuredDataInputStream input) {
		int type = input.input.readVarUInt();
		switch (type) {
			case StructuredFieldType.TYPE_BOOL:
				return BoolFieldType.INSTANCE;
			case StructuredFieldType.TYPE_INT:
				return IntFieldType.INSTANCE;
			case StructuredFieldType.TYPE_LONG:
				return LongFieldType.INSTANCE;
			case StructuredFieldType.TYPE_FLOAT:
				return FloatFieldType.INSTANCE;
			case StructuredFieldType.TYPE_DOUBLE:
				return DoubleFieldType.INSTANCE;
			case StructuredFieldType.TYPE_STRING:
				return StringFieldType.INSTANCE;
			case StructuredFieldType.TYPE_OBJECT:
				return new ObjectFieldType(input.input.readUUID());
			case StructuredFieldType.TYPE_UUID:
				return UUIDFieldType.INSTANCE;
			case StructuredFieldType.TYPE_OBJECTLIST:
				return new ObjectListFieldType(input.input.readUUID());
			case StructuredFieldType.TYPE_BYTEARRAY:
				return ByteArrayFieldType.INSTANCE;
			case StructuredFieldType.TYPE_STRUCT:
				UUID id = input.input.readUUID();
				return input.getStructType(id);
			default:
				throw new RuntimeException("Invalid field type: " + type);
		}
	}
	
	public void serialize(StructuredDataOutputStream output) {
		output.output.writeVarUInt(id);
		output.output.writeString(name);
		type.serialize(output);
	}
}
