/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.entitysyncer.datasets.stored;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openzen.entitysyncer.datasets.Dataset;
import org.openzen.entitysyncer.datasets.DatasetSubscriber;
import org.openzen.entitysyncer.datasets.DatasetSubscription;
import org.openzen.entitysyncer.datasets.stored.DeltaDataset;
import org.openzen.packetstreams.ByteString;
import org.openzen.packetstreams.io.BytesDataInput;
import org.openzen.packetstreams.io.BytesDataOutput;
import org.openzen.packetstreams.io.DataOutput;
import org.openzen.packetstreams.io.RuntimeIOException;

public class StoredDataset
implements Dataset {
    private static final int INDEX_SIZE = 16384;
    private final RandomAccessFile randomAccessFile;
    private final DeltaDataset dataset;
    private final Map<ByteString, BlockIndex> index = new HashMap<ByteString, BlockIndex>();
    private IndexBlock lastIndexBlock;
    private BlockIndex lastBlock;
    private final List<StoredDatasetSubscription> subscriptions = new ArrayList<StoredDatasetSubscription>();

    /*
     * Unable to fully structure code
     */
    public StoredDataset(File file, DeltaDataset dataset) throws IOException {
        super();
        this.dataset = dataset;
        this.randomAccessFile = new RandomAccessFile(file, "rw");
        if (file.exists()) {
            this.lastIndexBlock = new IndexBlock(0L, 16384);
            this.lastIndexBlock.writeHeader(this.randomAccessFile);
            initialData = dataset.getState();
            initialDataIndex = new BlockIndex(this.randomAccessFile.length(), initialData.length, dataset.getVersion());
            this.addBlockIndex(initialDataIndex);
            this.lastBlock = initialDataIndex;
            this.randomAccessFile.seek(this.randomAccessFile.length());
            this.randomAccessFile.write(initialData);
        } else {
            indexBlock = new IndexBlock(0L, this.randomAccessFile);
            while (true) {
                for (BlockIndex index : IndexBlock.access$000(indexBlock)) {
                    this.index.put(new ByteString(BlockIndex.access$100(index)), index);
                }
                if (IndexBlock.access$200(indexBlock) == 0L) break;
                indexBlock = new IndexBlock(IndexBlock.access$200(indexBlock), this.randomAccessFile);
                var4_6 = IndexBlock.access$000(indexBlock).iterator();
                while (true) {
                    if (!var4_6.hasNext()) ** continue;
                    block = (BlockIndex)var4_6.next();
                    if (this.lastBlock != null) {
                        BlockIndex.access$302(this.lastBlock, block);
                    }
                    this.lastBlock = block;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(byte[] version, byte[] delta) {
        try {
            BlockIndex newBlock = new BlockIndex(this.randomAccessFile.length(), delta.length, version);
            this.addBlockIndex(newBlock);
            this.randomAccessFile.seek(this.randomAccessFile.length());
            this.randomAccessFile.write(delta);
            this.lastBlock.next = newBlock;
            this.lastBlock = newBlock;
            List<StoredDatasetSubscription> list = this.subscriptions;
            synchronized (list) {
                for (StoredDatasetSubscription subscription : this.subscriptions) {
                    subscription.subscriber.onUpdated(version, delta);
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeIOException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatasetSubscription connect(DatasetSubscriber subscriber) {
        byte[] state = this.dataset.getState();
        subscriber.onNewState(this.lastBlock.version, state);
        List<StoredDatasetSubscription> list = this.subscriptions;
        synchronized (list) {
            StoredDatasetSubscription subscription = new StoredDatasetSubscription(subscriber);
            this.subscriptions.add(subscription);
            return subscription;
        }
    }

    @Override
    public DatasetSubscription connect(byte[] oldVersion, DatasetSubscriber subscriber) {
        BlockIndex versionIndex = this.index.get(new ByteString(oldVersion));
        if (versionIndex == null) {
            return this.connect(subscriber);
        }
        while (versionIndex != null) {
            try {
                byte[] data = versionIndex.read(this.randomAccessFile);
                subscriber.onUpdated(versionIndex.version, data);
                versionIndex = versionIndex.next;
            }
            catch (IOException ex) {
                throw new RuntimeException("Could not load versions!", ex);
            }
        }
        StoredDatasetSubscription subscription = new StoredDatasetSubscription(subscriber);
        this.subscriptions.add(subscription);
        return subscription;
    }

    private void addBlockIndex(BlockIndex index) throws IOException {
        this.index.put(new ByteString(index.version), index);
        BytesDataOutput output = new BytesDataOutput();
        index.write((DataOutput)output);
        byte[] encoded = output.toByteArray();
        if (this.lastIndexBlock.sizeInBytes + encoded.length > this.lastIndexBlock.capacityInBytes) {
            long startOfNewBlock = this.randomAccessFile.length();
            this.lastIndexBlock.writeNextBlockOffset(this.randomAccessFile, startOfNewBlock);
            this.lastIndexBlock = new IndexBlock(this.randomAccessFile.length(), 16384);
            this.lastIndexBlock.writeHeader(this.randomAccessFile);
        }
        this.lastIndexBlock.writeIndexBlock(this.randomAccessFile, encoded);
    }

    private class StoredDatasetSubscription
    implements DatasetSubscription {
        private final DatasetSubscriber subscriber;

        public StoredDatasetSubscription(DatasetSubscriber subscriber) {
            this.subscriber = subscriber;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            List list = StoredDataset.this.subscriptions;
            synchronized (list) {
                StoredDataset.this.subscriptions.remove(this);
            }
        }
    }

    private static class BlockIndex {
        private long offset;
        private int size;
        private byte[] version;
        private BlockIndex next;

        public BlockIndex(long offset, int size, byte[] version) {
            this.offset = offset;
            this.size = size;
            this.version = version;
        }

        public byte[] read(RandomAccessFile data) throws IOException {
            data.seek(this.offset);
            byte[] result = new byte[this.size];
            data.readFully(result);
            return result;
        }

        public void write(DataOutput output) {
            output.writeVarULong(this.offset);
            output.writeVarUInt(this.size);
            output.writeByteArray(this.version);
        }
    }

    private static class IndexBlock {
        private final List<BlockIndex> indexes = new ArrayList<BlockIndex>();
        private final long offset;
        private final int capacityInBytes;
        private long nextOffset;
        private int sizeInBytes;

        public IndexBlock(long offset, int capacityInBytes) {
            this.offset = offset;
            this.capacityInBytes = capacityInBytes;
            this.nextOffset = 0L;
            this.sizeInBytes = 0;
        }

        public IndexBlock(long offset, RandomAccessFile file) throws IOException {
            long blockOffset;
            this.offset = offset;
            file.seek(offset);
            this.capacityInBytes = file.readInt();
            byte[] data = new byte[this.capacityInBytes - 12];
            file.readFully(data);
            BytesDataInput input = new BytesDataInput(data);
            while ((blockOffset = input.readVarULong()) != 0L) {
                int size = input.readVarUInt();
                byte[] version = input.readByteArray();
                this.indexes.add(new BlockIndex(blockOffset, size, version));
            }
        }

        public void add(BlockIndex index, int sizeInBytes) {
            this.indexes.add(index);
            this.sizeInBytes += sizeInBytes;
        }

        public void writeHeader(RandomAccessFile file) throws IOException {
            file.seek(this.offset);
            file.writeLong(this.nextOffset);
            file.writeInt(this.sizeInBytes);
            file.write(new byte[this.capacityInBytes - 12]);
        }

        public void writeIndexBlock(RandomAccessFile file, byte[] data) throws IOException {
            file.seek(this.offset + (long)this.sizeInBytes);
            file.write(data);
            this.sizeInBytes += data.length;
        }

        public void writeNextBlockOffset(RandomAccessFile file, long nextOffset) throws IOException {
            this.nextOffset = nextOffset;
            file.seek(this.offset);
            file.writeLong(nextOffset);
        }

        static /* synthetic */ List access$000(IndexBlock x0) {
            return x0.indexes;
        }

        static /* synthetic */ long access$200(IndexBlock x0) {
            return x0.nextOffset;
        }
    }
}

