/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.entitysyncer.structured;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.openzen.entitysyncer.structured.StructuredClassRegistry;
import org.openzen.entitysyncer.structured.StructuredDataset;
import org.openzen.entitysyncer.structured.StructuredObject;
import org.openzen.entitysyncer.structured.definition.StructFieldType;
import org.openzen.entitysyncer.structured.definition.StructuredObjectClass;
import org.openzen.packetstreams.io.DataInput;

public class StructuredDataInputStream {
    private final StructuredClassRegistry registry;
    private final List<UUID> classIds = new ArrayList<UUID>();
    private final Map<UUID, Integer> classIndices = new HashMap<UUID, Integer>();
    public final StructuredDataset dataset;
    public final DataInput input;

    public StructuredDataInputStream(StructuredClassRegistry registry, StructuredDataset dataset, DataInput input) {
        this.registry = registry;
        this.dataset = dataset;
        this.input = input;
        this.classIds.add(null);
        this.classIds.add(null);
    }

    public StructuredObject readStructuredObject() {
        UUID clsid = this.readClass();
        if (!this.registry.knows(clsid)) {
            throw new RuntimeException("Unknown class: " + clsid);
        }
        return this.registry.read(clsid, this);
    }

    public StructFieldType<?> getStructType(UUID id) {
        StructFieldType<?> result = this.registry.getStructType(id);
        if (result == null) {
            throw new RuntimeException("Unknown struct type: " + id);
        }
        return result;
    }

    public StructuredObjectClass getStructuredClass(UUID id) {
        return this.registry.getStructuredClass(id);
    }

    private UUID readClass() {
        int id = this.input.readVarUInt();
        if (id == 0) {
            UUID uuid = this.input.readUUID();
            int newid = this.classIds.size();
            this.classIds.add(uuid);
            this.classIndices.put(uuid, newid);
            return uuid;
        }
        if (id == 1) {
            StructuredObjectClass definition = new StructuredObjectClass(this);
            if (!this.registry.knows(definition.id)) {
                this.registry.register(definition);
            }
            int newid = this.classIds.size();
            this.classIds.add(definition.id);
            this.classIndices.put(definition.id, newid);
            return definition.id;
        }
        return this.classIds.get(id);
    }
}

