/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.entitysyncer.structured;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.openzen.entitysyncer.structured.StructuredClassRegistry;
import org.openzen.entitysyncer.structured.StructuredDataset;
import org.openzen.entitysyncer.structured.StructuredObject;
import org.openzen.entitysyncer.structured.definition.StructuredFieldDefinition;
import org.openzen.packetstreams.io.DataOutput;

public class StructuredDataOutputStream {
    private final StructuredClassRegistry registry;
    private final List<UUID> classIds = new ArrayList<UUID>();
    private final Map<UUID, Integer> classIndices = new HashMap<UUID, Integer>();
    public final DataOutput output;
    public final StructuredDataset dataset;

    public StructuredDataOutputStream(StructuredClassRegistry registry, StructuredDataset dataset, DataOutput output) {
        this.registry = registry;
        this.dataset = dataset;
        this.output = output;
        this.classIds.add(null);
        this.classIds.add(null);
    }

    public void write(StructuredObject object) {
        UUID clsid = object.getStructuredClass().id;
        if (this.classIndices.containsKey(clsid)) {
            this.output.writeVarUInt(this.classIndices.get(clsid).intValue());
        } else if (this.registry.knows(clsid)) {
            int index = this.classIds.size();
            this.classIds.add(clsid);
            this.classIndices.put(clsid, index);
            this.output.writeVarUInt(0);
            this.output.writeUUID(clsid);
        } else {
            this.output.writeVarUInt(1);
            int index = this.classIds.size();
            this.classIds.add(clsid);
            this.classIndices.put(clsid, index);
            this.output.writeVarUInt(1);
            object.getStructuredClass().serialize(this);
        }
        this.writeContents(object);
    }

    private void writeContents(StructuredObject object) {
        long fieldMask = 0L;
        StructuredFieldDefinition[] fields = object.getStructuredClass().getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i] == null) continue;
            fieldMask |= 1L << i;
        }
        this.output.writeVarULong(fieldMask);
        for (StructuredFieldDefinition field : fields) {
            if (field == null) continue;
            field.type.write(this, object.getField(object.getStructuredClass().id, field.id));
        }
    }
}

