/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.live.field;

import org.openzen.entitysyncer.live.LiveDouble;
import org.openzen.entitysyncer.live.LiveDoubleFunction;
import org.openzen.entitysyncer.live.LiveFloat;
import org.openzen.entitysyncer.live.LiveLong;
import org.openzen.entitysyncer.live.LiveLongFunction;
import org.openzen.entitysyncer.structured.StructuredObject;
import org.openzen.entitysyncer.structured.definition.FloatFieldType;
import org.openzen.entitysyncer.structured.definition.StructuredFieldType;

/**
 *
 * @author Hoofdgebruiker
 */
public class LiveFloatField extends LiveBaseNumberField implements LiveFloat {
	private float value;
	
	public LiveFloatField() {
		value = 0;
	}
	
	public LiveFloatField(float value) {
		this.value = value;
	}
	
	@Override
	public float get() {
		return value;
	}
	
	public void set(float value) {
		this.value = value;
		publish();
	}
	
	@Override
	public void clear() {
		set(0);
	}
	
	@Override
	public StructuredFieldType getType() {
		return FloatFieldType.INSTANCE;
	}

	@Override
	public boolean asBoolValue() {
		return value != 0;
	}

	@Override
	public int asIntValue() {
		return (int) value;
	}
	
	@Override
	public LiveLong asLong() {
		return new LiveLongFunction(() -> (long)value, v -> set(value), this);
	}

	@Override
	public long asLongValue() {
		return (long) value;
	}
	
	@Override
	public LiveFloat asFloat() {
		return this;
	}

	@Override
	public float asFloatValue() {
		return value;
	}
	
	@Override
	public LiveDouble asDouble() {
		return new LiveDoubleFunction(() -> value, v -> set((float) v), this);
	}

	@Override
	public double asDoubleValue() {
		return value;
	}

	@Override
	public String asStringValue() {
		return Float.toString(value);
	}

	@Override
	public StructuredObject asObjectValue() {
		throw new ClassCastException("Cannot cast int to an object");
	}
}
