/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openzen.entitysyncer.live.field;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.openzen.entitysyncer.live.LiveBool;
import org.openzen.entitysyncer.live.LiveByteArray;
import org.openzen.entitysyncer.live.LiveDouble;
import org.openzen.entitysyncer.live.LiveFloat;
import org.openzen.entitysyncer.live.LiveInt;
import org.openzen.entitysyncer.live.LiveLong;
import org.openzen.entitysyncer.live.LiveObject;
import org.openzen.entitysyncer.live.LiveObjectList;
import org.openzen.entitysyncer.live.LiveString;
import org.openzen.entitysyncer.live.LiveUUID;
import org.openzen.entitysyncer.live.SubscribableList;
import org.openzen.entitysyncer.live.any.LiveStruct;
import org.openzen.entitysyncer.structured.StructuredObject;
import org.openzen.entitysyncer.structured.definition.ObjectListFieldType;

/**
 *
 * @author Hoofdgebruiker
 */
public class LiveObjectListField<T extends StructuredObject> extends SubscribableList implements LiveField, LiveObjectList<T> {
	private final ObjectListFieldType type;
	private final List<T> values = new ArrayList<>();
	
	public LiveObjectListField(ObjectListFieldType type) {
		this.type = type;
	}
	
	public LiveObjectListField(ObjectListFieldType type, List<T> values) {
		this.type = type;
		this.values.addAll(values);
	}
	
	@Override
	public void clear() {
		values.clear();
	}
	
	@Override
	public ObjectListFieldType getType() {
		return type;
	}
	
	@Override
	public List<T> get() {
		return Collections.unmodifiableList(values);
	}
	
	@Override
	public void add(T value) {
		int index = values.size();
		values.add(value);
		publishInserted(index, value);
	}
	
	public void insert(int index, T value) {
		values.add(index, value);
		publishInserted(index, value);
	}
	
	public void set(int index, T value) {
		T current = values.set(index, value);
		publishUpdated(index, current, value);
	}
	
	public void remove(int index) {
		T value = values.remove(index);
		publishRemoved(index, value);
	}

	@Override
	public LiveBool asBool() {
		throw new ClassCastException("Cannot cast object list to bool");
	}

	@Override
	public boolean asBoolValue() {
		throw new ClassCastException("Cannot cast object list to bool");
	}

	@Override
	public LiveInt asInt() {
		throw new ClassCastException("Cannot cast object list to int");
	}

	@Override
	public int asIntValue() {
		throw new ClassCastException("Cannot cast object list to int");
	}

	@Override
	public LiveLong asLong() {
		throw new ClassCastException("Cannot cast object list to long");
	}

	@Override
	public long asLongValue() {
		throw new ClassCastException("Cannot cast object list to long");
	}

	@Override
	public LiveFloat asFloat() {
		throw new ClassCastException("Cannot cast object list to float");
	}

	@Override
	public float asFloatValue() {
		throw new ClassCastException("Cannot cast object list to float");
	}

	@Override
	public LiveDouble asDouble() {
		throw new ClassCastException("Cannot cast object list to double");
	}

	@Override
	public double asDoubleValue() {
		throw new ClassCastException("Cannot cast object list to double");
	}

	@Override
	public LiveString asString() {
		throw new ClassCastException("Cannot cast object list to string");
	}
	
	@Override
	public String asStringValue() {
		throw new ClassCastException("Cannot cast object list to string");
	}
	
	@Override
	public LiveUUID asUUID() {
		throw new ClassCastException("Cannot cast object list to uuid");
	}
	
	@Override
	public UUID asUUIDValue() {
		throw new ClassCastException("Cannot cast object list to uuid");
	}
	
	@Override
	public LiveByteArray asByteArray() {
		throw new ClassCastException("Cannot cast object list to byte array");
	}
	
	@Override
	public byte[] asByteArrayValue() {
		throw new ClassCastException("Cannot cast object list to byte array");
	}

	@Override
	public LiveObject<?> asObject() {
		throw new ClassCastException("Cannot cast object list to object");
	}

	@Override
	public StructuredObject asObjectValue() {
		throw new ClassCastException("Cannot cast object list to object");
	}

	@Override
	public LiveObjectList<T> asObjectList() {
		return this;
	}

	@Override
	public <T extends LiveStruct> T asStruct(Class<T> cls) {
		throw new ClassCastException("Cannot cast object to struct");
	}
}
