/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.entitysyncer.datasets.stored;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.openzen.entitysyncer.datasets.Dataset;
import org.openzen.entitysyncer.datasets.DatasetProvider;
import org.openzen.entitysyncer.datasets.stored.DeltaDataset;
import org.openzen.entitysyncer.datasets.stored.DeltaDatasetProvider;
import org.openzen.entitysyncer.datasets.stored.StoredDataset;
import org.openzen.packetstreams.crypto.CryptoPublicKey;

public class StoredDatasetProvider
implements DatasetProvider {
    private final File directory;
    private final String type;
    private final Map<Long, StoredDataset> loadedDatasetsByID = new HashMap<Long, StoredDataset>();
    private final Map<UUID, StoredDataset> loadedDatasetsByUUID = new HashMap<UUID, StoredDataset>();
    private final DeltaDatasetProvider provider;

    public StoredDatasetProvider(File directory, String type, DeltaDatasetProvider provider) {
        this.directory = directory;
        this.type = type;
        this.provider = provider;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Dataset getById(CryptoPublicKey clientPublicKey, long id) {
        Map<Long, StoredDataset> map = this.loadedDatasetsByID;
        synchronized (map) {
            if (this.loadedDatasetsByID.containsKey(id)) {
                return this.loadedDatasetsByID.get(id);
            }
            DeltaDataset deltaDataset = this.provider.getById(id);
            if (deltaDataset == null) {
                return null;
            }
            try {
                File file = new File(this.directory, Long.toString(id));
                StoredDataset dataset = new StoredDataset(file, deltaDataset);
                this.loadedDatasetsByID.put(id, dataset);
                return dataset;
            }
            catch (IOException ex) {
                throw new RuntimeException("Cannot load dataset", ex);
            }
        }
    }

    @Override
    public Dataset getByUUID(CryptoPublicKey clientPublicKey, UUID uuid) {
        Map<UUID, StoredDataset> map = this.loadedDatasetsByUUID;
        synchronized (map) {
            if (this.loadedDatasetsByUUID.containsKey(uuid)) {
                return this.loadedDatasetsByUUID.get(uuid);
            }
            DeltaDataset deltaDataset = this.provider.getByUUID(uuid);
            if (deltaDataset == null) {
                return null;
            }
            try {
                File file = new File(this.directory, uuid.toString());
                StoredDataset dataset = new StoredDataset(file, deltaDataset);
                this.loadedDatasetsByUUID.put(uuid, dataset);
                return dataset;
            }
            catch (IOException ex) {
                throw new RuntimeException("Cannot load dataset", ex);
            }
        }
    }
}

