/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.entitysyncer.live.field;

import org.openzen.entitysyncer.live.LiveDouble;
import org.openzen.entitysyncer.live.field.LiveBaseNumberField;
import org.openzen.entitysyncer.structured.StructuredObject;
import org.openzen.entitysyncer.structured.definition.DoubleFieldType;
import org.openzen.entitysyncer.structured.definition.StructuredFieldType;

public class LiveDoubleField
extends LiveBaseNumberField
implements LiveDouble {
    private double value;

    public LiveDoubleField() {
        this.value = 0.0;
    }

    public LiveDoubleField(double value) {
        this.value = value;
    }

    @Override
    public double get() {
        return this.value;
    }

    @Override
    public void set(double value) {
        this.value = value;
        this.publish();
    }

    @Override
    public void clear() {
        this.set(0.0);
    }

    @Override
    public StructuredFieldType getType() {
        return DoubleFieldType.INSTANCE;
    }

    @Override
    public boolean asBoolValue() {
        return this.value != 0.0;
    }

    @Override
    public int asIntValue() {
        return (int)this.value;
    }

    @Override
    public long asLongValue() {
        return (long)this.value;
    }

    @Override
    public float asFloatValue() {
        return (float)this.value;
    }

    @Override
    public LiveDouble asDouble() {
        return this;
    }

    @Override
    public double asDoubleValue() {
        return this.value;
    }

    @Override
    public String asStringValue() {
        return Double.toString(this.value);
    }

    @Override
    public StructuredObject asObjectValue() {
        throw new ClassCastException("Cannot cast double to an object");
    }
}

